import React from 'react';
import noDeviceConnectedIcon from 'resources/images/no_device_connected.svg';
import useStyles from './styles';

type Props = {
    strings: object,
    onNeedSupport: () => {}
};

function NoDeviceConnected({ strings, onNeedSupport }: Props) {
    const classes = useStyles();
    return (
        <div className={classes.noDeviceConnectedContainer}>
            <img
                className={classes.noDeviceConnectedIcon}
                src={noDeviceConnectedIcon}
                alt="No Device Icon"
            />
            <div className={classes.noDeviceConnectedDescription}>
                {strings.welcome_no_device_connected_description}
            </div>
            <div
                className={classes.noDeviceConnectedNeedSupport}
                onClick={onNeedSupport}
            >
                {strings.general_link_need_support}
            </div>
        </div>
    );
}

export default NoDeviceConnected;
